/*
overlay a Bitte warten text into the framebuffer
*/

#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>
#include <linux/fb.h>
#include <sys/mman.h>
#include <sys/ioctl.h>
#include "targa.h"

int main()
{
    int fbfd = 0;
    struct fb_var_screeninfo vinfo;
    struct fb_fix_screeninfo finfo;
    long int screensize = 0;
    char *fbp = 0;
    int x = 0, y = 0;
    int ox=0, oy=0;
    long int location = 0;
    int width =0, height = 0;
    uint8_t *pixpointer = NULL;
    tga_image img;
    tga_result res;

    // Open the file for reading and writing
    fbfd = open("/dev/fb0", O_RDWR);
    if (fbfd == -1) {
        perror("Error: cannot open framebuffer device");
        exit(1);
    }
    //printf("The framebuffer device was opened successfully.\n");

    // Get fixed screen information
    if (ioctl(fbfd, FBIOGET_FSCREENINFO, &finfo) == -1) {
        perror("Error reading fixed information");
        exit(2);
    }

    // Get variable screen information
    if (ioctl(fbfd, FBIOGET_VSCREENINFO, &vinfo) == -1) {
        perror("Error reading variable information");
        exit(3);
    }

    //printf("%dx%d, %dbpp\n", vinfo.xres, vinfo.yres, vinfo.bits_per_pixel);

    // Figure out the size of the screen in bytes
    screensize = vinfo.xres * vinfo.yres * vinfo.bits_per_pixel / 8;

    // Map the device to memory
    fbp = (char *)mmap(0, screensize, PROT_READ | PROT_WRITE, MAP_SHARED, fbfd, 0);
    if ((int)fbp == -1) {
        perror("Error: failed to map framebuffer device to memory");
        exit(4);
    }
    //printf("The framebuffer device was mapped to memory successfully.\n");


    // open the TGA file and read it into memory
    res = tga_read(&img, "bittewarten.tga");
    if (res != TGA_NOERR) {
	    perror("Error reading TGA file.\n)");
	    exit(4);
    }

    width=img.width; height=img.height;
    ox = 190; oy = 200;       // Where we are going to put the pixel

    // Figure out where in memory to put the pixel
    for (y=oy ; y < oy+height; y++)
        for (x = ox; x < ox+width; x++) {
	    pixpointer = tga_find_pixel(&img, x-ox, y-oy);
            location = (x+vinfo.xoffset) * (vinfo.bits_per_pixel/8) +
                       (y+vinfo.yoffset) * finfo.line_length;
	    if (*pixpointer != 0) {
    	        *(fbp + location)     = *pixpointer;
	        *(fbp + location + 1) = *(pixpointer+1);
	        *(fbp + location + 2) = *(pixpointer+2);
                *(fbp + location + 3) = 0;      // No transparency
	   }
        }
    munmap(fbp, screensize);
    close(fbfd);
    tga_free_buffers(&img);

    return 0;
}
