<?php
/* This file is part of the wp-forecast plugin for wordpress */

/*  Copyright 2006,2007  Hans Matzen  (email : webmaster at tuxlog.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//
// this function fetches an url an returns it as one whole string
//
function fetchURL($url) 
{
    $url_parsed = parse_url($url);
    $host = $url_parsed["host"];
    if (!isset($url_parsed["port"])) {
	$port = 80;
    }
    else {
	$port = $url_parsed["port"];
    }
    $path = $url_parsed["path"];
    if ($url_parsed["query"] != "") $path .= "?" . $url_parsed["query"];
    $out = "GET $path HTTP/1.0\r\nHost: $host\r\n\r\n";
    $fp = fsockopen($host, $port, $errno, $errstr, 30);
    fwrite($fp, $out);
    $body = false;
    $in = "";
    while (!feof($fp)) {
	$s = fgets($fp, 1024);
	if ($body) $in .= $s;
        if ($s == "\r\n") $body = true;
    }
    fclose($fp);
    return $in;
}

//
// converts an array to an cookie like string
// e.g. a=5&b=6&c=7
function arr2str($a)
{
    $s="";
    foreach ($a as $name => $value){
	$s=$s . $name . "=" . $value . "&";
    }
    return $s;
}

//
// converts a cookie like string (see above) to an array
//
function str2arr($s)
{
    $a=array();
    parse_str($s,$a);
    return $a;
}
