<?php
/* This file is part of the wp-forecast plugin for wordpress */

/*  Copyright 2006,2007  Hans Matzen  (email : webmaster at tuxlog.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//
// this function is called with the language code and returns an array
// with the corresponding translations for wp-forecast
//
function set_translation($LANGUAGE)
{
    $tl=array();
    if ($LANGUAGE=="en") {
        // Translated Labels
	$tl['title'] = "Weather";
	$tl['time']  = "time";
	$tl['barr']  = "current pressure";
	$tl['tmp']   = "current temperature";
	$tl['flik']  = "real feel";
	$tl['hmid']  = "humidity";
	$tl['t']     = "forecast summary";
	$tl['windgust'] = "wind gust speed";
	$tl['winds'] = "wind speed";
	$tl['windt'] = "wind direction (text)";
	$tl['to']    = "to";
	$tl['sunrise'] = "sunrise";
	$tl['sunset'] = "sunset";
	$tl['Forecast'] = "Forecast";
	$tl['Monday'] = "Monday";
	$tl['Tuesday'] = "Tuesday";
	$tl['Wednesday'] = "Wednesday";
	$tl['Thursday'] = "Thursday";
	$tl['Friday'] = "Friday";
	$tl['Saturday'] = "Saturday";
	$tl['Sunday'] = "Sunday";
	$tl['day'] = "day";
	$tl['night'] = "night";

        // ::::: Translated Forecasts ::::: 
	$tl['01'] = 'Sunny';
	$tl['02'] = 'Mostly sunny';
	$tl['03'] = 'Partly sunny';
	$tl['04'] = 'Intermittent clouds';
	$tl['05'] = 'Hazy sunshine';
	$tl['06'] = 'Mostly cloudy';
	$tl['07'] = 'Cloudy';
	$tl['08'] = 'Dreary (overcast)';
	$tl['11'] = 'Fog';
	$tl['12'] = 'Showers';
	$tl['13'] = 'Mostly cloudy with showers';
	$tl['14'] = 'Partly sunny with showers';
	$tl['15'] = 'Thunderstorms';
	$tl['16'] = 'Mostly cloudy with thundershowers';
	$tl['17'] = 'Partly sunny with thundershowers';
	$tl['18'] = 'Rain';
	$tl['19'] = 'Flurries';
	$tl['20'] = 'Mostly cloudy with flurries';
	$tl['21'] = 'Partly sunny with flurries';
	$tl['22'] = 'Snow';
	$tl['23'] = 'Mostly cloudy with snow';
	$tl['24'] = 'Ice';
	$tl['25'] = 'Sleet';
	$tl['26'] = 'Freezing rain';
	$tl['29'] = 'Rain and snow';
	$tl['30'] = 'Hot';
	$tl['31'] = 'Cold';
	$tl['32'] = 'Windy';

        // night
	$tl['33'] = 'Clear';
	$tl['34'] = 'Mostly clear';
	$tl['35'] = 'Partly cloudy';
	$tl['36'] = 'Intermittent clouds';
	$tl['37'] = 'Hazy moonlight';
	$tl['38'] = 'Mostly cloudy';
	$tl['39'] = 'Partly cloudy with showers';
	$tl['40'] = 'Mostly cloudy with showers';
	$tl['41'] = 'Partly cloudy with thunderstorms';
	$tl['42'] = 'Mostly cloudy with thunderstorms';
	$tl['43'] = 'Mostly cloudy with flurries';
	$tl['44'] = 'Mostly cloudy with snow';

	// admin page
	$tl['Refresh cache after'] = 'Refresh cache after';
	$tl['secs'] = 'secs.';
	$tl['Use metric units'] = 'Use metric units';
	$tl['Language'] = 'Language';
	$tl['Forecast'] = 'Forecast';
	$tl['Daytime'] = 'Daytime';
	$tl['Nighttime'] = 'Nighttime';
	$tl['Day'] = 'Day';
	$tl['Display Configuration'] = 'Display Configuration';
	$tl['Current Conditions'] = 'Current Conditions';
	$tl['Forecast Day'] = 'Forecast Day';
	$tl['Forecast Night'] = 'Forecast Night';
	$tl['Icon'] = 'Icon';	
	$tl['Time'] = 'Time';
	$tl['Short Description'] = 'Short Description';
	$tl['Temperature'] = 'Temperature';
	$tl['Realfeel'] = 'Realfeel';
	$tl['Pressure'] = 'Pressure';
	$tl['Humidity'] = 'Humidity';
	$tl['Wind'] = 'Wind';	
	$tl['Sunrise'] = 'Sunrise';
	$tl['Sunset'] = 'Sunset';
	$tl['n/a'] = 'n/a';
	$tl['Location'] = 'Location';
	$tl['Update options'] = 'Update options';
	$tl['Search location'] = 'Search location';
	$tl['Set location'] = 'Set location';
	$tl['Searchterm'] = 'Searchterm';
	$tl['WP-Forecast Setup'] = 'WP-Forecast Setup';
	$tl['You have to change a field to update settings.'] = 'You have to change a field to update settings.';
	$tl['Please select your city and press set location.'] = 'Please select your city and press set location.';
	$tl['Search result'] = 'Search result';
	$tl['Press Update options to save new location.'] = 'Press Update options to save new location.';
	$tl['Settings successfully updated'] = 'Settings successfully updated';
	$tl['Windspeed-Unit'] = 'Windspeed-Unit';
	$tl['Meter/Second (m/s)'] = 'Meter/Second (m/s)';
	$tl['Kilometer/Hour (km/h)'] = 'Kilometer/Hour (km/h)';
	$tl['Miles/Hour (mph)'] = 'Miles/Hour (mph)';
	$tl['Knots (kts)'] = 'Knots (kts)';
	$tl['No locations found.']="No locations found.";
	$tl['Please replace german Umlaute ä,ö,ü with a, o, u in your searchterm.'] = 'Please replace german Umlaute ä,ö,ü with a, o, u in your searchterm.';
	$tl['Sorry, no valid weather data available.'] = "Sorry, no valid weather data available.";
	$tl['Please try again later.'] = "Please try again later.";
    }

    if ($LANGUAGE=="de"){
	// Translated Labels
	$tl['title'] = "Das Wetter";
	$tl['loc']   = "Ort";
	$tl['time']  = "Uhrzeit";
	$tl['barr']  = "Aktueller Luftdruck";
	$tl['tmp']   = "Aktuelle Temperatur";
	$tl['tmp1']  = "Temperatur";
	$tl['flik']  = "Gefühlte Temperatur";
	$tl['hmid']  = "Luftfeuchtigkeit";
	$tl['t']     = "Kurze Zusammenfassung der Vorhersage (z.B. 'sunny')";
	$tl['windgust'] = "Windböengeschwindigkeit";
	//$tl['winds'] = "Windgeschwindigkeit";
	$tl['winds'] = "Wind";
	$tl['windt'] = "Windrichtung (Text)";
	$tl['to']    = "bis";
	$tl['sunrise'] = "Sonnenaufgang";
	$tl['sunset'] = "Sonnenuntergang";
	$tl['Forecast'] = "Vorschau";
	$tl['Monday'] = "Montag";
	$tl['Tuesday'] = "Dienstag";
	$tl['Wednesday'] = "Mittwoch";
	$tl['Thursday'] = "Donnerstag";
	$tl['Friday'] = "Freitag";
	$tl['Saturday'] = "Samstag";
	$tl['Sunday'] = "Sonntag";
	$tl['day'] = "Tag";
	$tl['night'] = "Nacht";

        // ::::: Translated Forecasts ::::: 
	$tl['01'] = 'Wolkenlos';
	$tl['02'] = 'Heiter';
	$tl['03'] = 'Heiter bis wolkig';
	$tl['04'] = 'Wolkig';
	$tl['05'] = 'Dunstiger Sonnenschein';
	$tl['06'] = 'Bewölkt';
	$tl['07'] = 'Stark bewölkt';
	$tl['08'] = 'Bedeckt';
	$tl['11'] = 'Nebel';
	$tl['12'] = 'Regenschauer';
	$tl['13'] = 'Bewölkt mit Regenschauern';
	$tl['14'] = 'Wolkig mit Regenschauern';
	$tl['15'] = 'Gewitter';
	$tl['16'] = 'Bewölkt mit Gewitterschauern';
	$tl['17'] = 'Wolkig mit Gewitterschauern';
	$tl['18'] = 'Regen';
	$tl['19'] = 'Schneeschauer';
	$tl['20'] = 'Bewölkt mit Schneeschauern';
	$tl['21'] = 'Wolkig mit Schneeschauern';
	$tl['22'] = 'Schneefall';
	$tl['23'] = 'Bewölkt mit Schneefall';
	$tl['24'] = 'Glatteis';
	$tl['25'] = 'Graupelschauer';
	$tl['26'] = 'Eisregen';
	$tl['29'] = 'Schneeregen';
	$tl['30'] = 'Heiß';
	$tl['31'] = 'Kalt';
	$tl['32'] = 'Windig';

        // night
	$tl['33'] = 'Klare Nacht';
	$tl['34'] = 'Überwiegend klar';
	$tl['35'] = 'Wolkig';
	$tl['36'] = 'Zeitweise wolkig';
	$tl['37'] = 'Dunstig';
	$tl['38'] = 'Bewölkt';
	$tl['39'] = 'Wolkig mit Regenschauern';
	$tl['40'] = 'Bewölkt mit Regenschauern';
	$tl['41'] = 'Wolkig mit Gewitterschauern';
	$tl['42'] = 'Bewölkt mit Gewitterschauern';
	$tl['43'] = 'Bewölkt mit Schneeschauern';
	$tl['44'] = 'Bewölkt mit Schneefall';

	// admin page
	$tl['Refresh cache after'] = 'Cache erneuern nach';
	$tl['secs.'] = 'Sekunden';
	$tl['Use metric units'] = 'metrische Einheiten verwenden';
	$tl['Language'] = 'Sprache';
	$tl['Forecast'] = 'Vorhersage';
	$tl['Daytime'] = 'tagsüber';
	$tl['Nighttime'] = 'nachts';
	$tl['Day'] = 'Tag';
	$tl['Display Configuration'] = 'Anzeige Einstellungen';
	$tl['Current Conditions'] = 'Aktuelles Wetter';
	$tl['Forecast Day'] = 'Vorhersage tagsüber';
	$tl['Forecast Night'] = 'Vorhersage nachts';
	$tl['Icon'] = 'Symbol';	
	$tl['Time'] = 'Zeit';
	$tl['Short Description'] = 'Kurzbezeichnung';
	$tl['Temperature'] = 'Temperatur';
	$tl['Realfeel'] = 'Gefühlte Temperatur';
	$tl['Pressure'] = 'Luftdruck';
	$tl['Humidity'] = 'Luftfeuchtigkeit';
	$tl['Wind'] = 'Wind';	
	$tl['Sunrise'] = 'Sonnenaufgang';
	$tl['Sunset'] = 'Sonnenuntergang';
	$tl['n/a'] = 'n/a';
	$tl['Location'] = 'Ort';
	$tl['Update options'] = 'Einstellungen speichern';
	$tl['Search location'] = 'Ort suchen';
	$tl['Set location'] = 'Ort übernehmen';
	$tl['Searchterm'] = 'Suchbegriff';
	$tl['WP-Forecast Setup'] = 'WP-Forecast Einstellungen';
	$tl['You have to change a field to update settings.'] = 'Um die Einstellungen zu aktualisieren, müssen Sie mindestens ein Feld verändern.';
	$tl['Please select your city and press set location.'] = 'Bitte einen Ort auswählen und Ort Übernehmen klicken.';
	$tl['Search result'] = 'Suchergebnis';
	$tl['Press Update options to save new location.'] = 'Klick auf Einstellungen speichern sichert den Ort.';
	$tl['Settings successfully updated'] = 'Die Einstellungen wurden erfolgreich gespeichert.';
	$tl['Windspeed-Unit'] = 'Einheit der Windgeschwindigkeit';
	$tl['Meter/Second (m/s)'] = 'Meter/Sekunde (m/s)';
	$tl['Kilometer/Hour (km/h)'] = 'Kilometer/Stunde (km/h)';
	$tl['Miles/Hour (mph)'] = 'Meilen/Stunde (mph)';
	$tl['Knots (kts)'] = 'Knoten (kts)';
	$tl['No locations found.'] = "Keine Orte gefunden.";
    	$tl['Please replace german Umlaute ä,ö,ü with a, o, u in your searchterm.'] = 'Bitte ersetzen Sie Umlaute im Suchbegriff durch die entsprechenden Vokale (z.B. ä durch a)';
    	$tl['Sorry, no valid weather data available.'] = "Aktuell liegen keine gültigen Wetterinformationen vor.";
	$tl['Please try again later.'] = "Bitte versuchen Sie es später nochmal.";
    }




    if ($LANGUAGE=="nl") {
      // Translated Labels
      $tl['title'] = 'Weer';
      $tl['time'] = 'tijd';
      $tl['barr'] = 'huidige druk';
      $tl['tmp'] = 'Huidige temperatuur';
      $tl['flik'] = 'gevoel';
      $tl['hmid'] = 'humidity';
      $tl['t'] = 'samenvatting verwachting';
      $tl['windgust'] = 'windstoten, snelheid';
      $tl['winds'] = 'wind snelheid';
      $tl['windt'] = 'wind richting (text)';
      $tl['to'] = 'tot';
      $tl['sunrise'] = 'zon opgang';
      $tl['sunset'] = 'zon ondergang';
      $tl['Forecast'] = 'Verwachting';
      $tl['Monday'] = 'Maandag';
      $tl['Tuesday'] = 'Dinsdag';
      $tl['Wednesday'] = 'Woensdag';
      $tl['Thursday'] = 'Donderdag';
      $tl['Friday'] = 'Vrijdag';
      $tl['Saturday'] = 'Zaterdag';
      $tl['Sunday'] = 'Zondag';
      $tl['day'] = 'dag';
      $tl['night'] = 'nacht';

      // ::::: Translated Forecasts :::::
      $tl['01'] = 'Zonnig';
      $tl['02'] = 'Meestal Zonnig';
      $tl['03'] = 'Deels Zonnig';
      $tl['04'] = 'Af en toe bewolking';
      $tl['05'] = 'Nevel';
      $tl['06'] = 'Meest bewolkt';
      $tl['07'] = 'Bewolkt';
      $tl['08'] = 'Somber (betrokken lucht)';
      $tl['11'] = 'Mist';
      $tl['12'] = 'Stortbuien';
      $tl['13'] = 'Meest bewolkt met regen';
      $tl['14'] = 'Deels zonnig met buien';
      $tl['15'] = 'Onweer';
      $tl['16'] = 'Meest bewolkt met onweersbuinen';
      $tl['17'] = 'Deels zonnig met onweersbuien';
      $tl['18'] = 'Regen';
      $tl['19'] = 'Hagel en Regen';
      $tl['20'] = 'Meest bewolkt en hagel en regen';
      $tl['21'] = 'Deels zonnig met hagel en regen';
      $tl['22'] = 'Sneeuw';
      $tl['23'] = 'Meest bewolkt met sneeuw';
      $tl['24'] = 'IJs';
      $tl['25'] = 'Natte Sneeuw';
      $tl['26'] = 'Hagelbuien';
      $tl['29'] = 'Regen en sneeuw';
      $tl['30'] = 'Heet';
      $tl['31'] = 'Koud';
      $tl['32'] = 'Winderig';
      
      // night
      $tl['33'] = 'Helder';
      $tl['34'] = 'Meest helder';
      $tl['35'] = 'Deels bewolkt';
      $tl['36'] = 'Af en toe bewolking';
      $tl['37'] = 'Nevelig';
      $tl['38'] = 'Meest bewolkt';
      $tl['39'] = 'Deels bewolkt met buien';
      $tl['40'] = 'Meest bewoikt met buien';
      $tl['41'] = 'Deels bewolkt met onweer';
      $tl['42'] = 'Meest bewolkt met onweer';
      $tl['43'] = 'Meest bewolkt met hagel en regen';
      $tl['44'] = 'Meest bewolkt met sneeuw';
      
      // admin page
      $tl['Refresh cache after'] = 'Ververs geheugen na';
      $tl['secs'] = 'sec.';
      $tl['Use metric units'] = 'Gebruik metriek stelsel';
      $tl['Language'] = 'Taal';
      $tl['Forecast'] = 'Voorspelling';
      $tl['Daytime'] = 'Overdag';
      $tl['Nighttime'] = 'Nacht';
      $tl['Day'] = 'Dag';
      $tl['Display Configuration'] = 'Weergeven Configuratie';
      $tl['Current Conditions'] = 'Huidig weerbeeld';
      $tl['Forecast Day'] = 'Voorspelling Dag';
      $tl['Forecast Night'] = 'Voorspelling Nacht';
      $tl['Icon'] = 'Ikoon';
      $tl['Time'] = 'Tijd';
      $tl['Short Description'] = 'Korte Omschrijving';
      $tl['Temperature'] = 'Temperatuur';
      $tl['Realfeel'] = 'Werkelijk gevoel';
      $tl['Pressure'] = 'Druk';
      $tl['Humidity'] = 'Vochtigheid';
      $tl['Wind'] = 'Wind';
      $tl['Sunrise'] = 'Zon opgang';
      $tl['Sunset'] = 'Zon ondergang';
      $tl['n/a'] = 'n/a';
      $tl['Location'] = 'Plaats';
      $tl['Update options'] = 'Bijwerken opties';
      $tl['Search location'] = 'Zoek plaats';
      $tl['Set location'] = 'Set lokatie';
      $tl['Searchterm'] = 'Zoek term';
      $tl['WP-Forecast Setup'] = 'WP-Voorspelling Instellingen';
      $tl['You have to change a field to update settings.'] = 'U moet een veld hebben gewijzigd om te kunnen bijwerken.';
      $tl['Please select your city and press set location.'] = 'Selecteer uw stad en druk op set lokatie.';
      $tl['Search result'] = 'Zoek resultaten';
      $tl['Press Update options to save new location.'] = 'Druk op bijwerken om nieuwe lokatie te bewaren.';
      $tl['Settings successfully updated'] = 'Succesvol bijgewerkt';
      $tl['Windspeed-Unit'] = 'Windsnelheid-Unit';
      $tl['Meter/Second (m/s)'] = 'Meter/Seconde (m/s)';
      $tl['Kilometer/Hour (km/h)'] = 'Kilometer/Uur (km/h)';
      $tl['Miles/Hour (mph)'] = 'Mijl/Uur (mph)';
      $tl['Knots (kts)'] = 'Knopen (knps)';
    }




    return $tl;
}
?>
