<?php
/* This file is part of the wp-forecast plugin for wordpress */

/*  Copyright 2006,2007  Hans Matzen  (email : webmaster at tuxlog.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

//
// setting up the default options in table wp-options during 
// plugin activation from the plugins page
//
function wp_forecast_activate()
{
  
    // get options just in case
    $location=get_option("wp-forecast-location");
    $refresh=get_option("wp-forecast-refresh"); 
    $metric=get_option("wp-forecast-metric"); 
    $wpf_language=get_option("wp-forecast-language");
    $daytime=get_option("wp-forecast-daytime");
    $nighttime=get_option("wp-forecast-nighttime");
    $dispconfig=get_option("wp-forecast-dispconfig");
    $windunit = get_option("wp-forecast-windunit");

    // if the options dont exists, add the defaults
    if ($location == "") {
	$location="EUR|DE|GM007|FRANKFURT AM MAIN";
	add_option("wp-forecast-location",$location,
		   "Contains the location code from accuweather","yes");
    };

    if ($refresh == "") {
	$refresh="600";
	add_option("wp-forecast-refresh",$refresh,
		   "Contains the intervall the local weather data is renewed",
		   "yes");
    };

    if ($metric == "") {
      $metric="1";
      add_option("wp-forecast-metric",$metric,
		 "1 if you want to use metric scheme, else 0","yes");
    };
    
    if ($wpf_language == "") {
      $wpf_language="en";
      add_option("wp-forecast-language",$wpf_language,
		 "The lanugage code","yes");
    };
    
    if ($daytime == "") {
      $daytime="000000000";
      add_option("wp-forecast-daytime",$daytime,
		 "Switches for Daytime forecast","yes");
    };
    
    if ($nighttime == "") {
      $nighttime="000000000";
      add_option("wp-forecast-nighttime",$nighttime,
		 "Switches for Nighttime forecast","yes");
    };

    if ($dispconfig == "") {
      $dispconfig="111111111111111111";
      add_option("wp-forecast-dispconfig",$dispconfig,
		 "Switches for shown Information","yes");
    }

    if ($windunit == "") {
      $windunit="ms";
      add_option("wp-forecast-windunit",$windunit,
		 "Choose between ms, kmh, mph or kts, else 0","yes");
    };
}

//
// is called when plugin is deactivated and removes all
// the  wp-forecast options from the database
//
function wp_forecast_deactivate() 
{
    delete_option("wp-forecast-location");
    delete_option("wp-forecast-refresh"); 
    delete_option("wp-forecast-metric"); 
    delete_option("wp-forecast-language");
    delete_option("wp-forecast-daytime");
    delete_option("wp-forecast-nighttime");
    delete_option("wp-forecast-dispconfig");
    delete_option("wp-forecast-windunit");
    // leave this for a while to wipe out old option settings
    delete_option("wp-forecast-days");
    
}
