<?php
/*
Plugin Name: wp-forecast
Plugin URI: http://www.tuxlog.de
Description: wp-forecast is a highly customizable plugin for wordpress, showing weather-data from accuweather.com.
Version: 0.9
Author: Hans Matzen <webmaster at tuxlog.de>
Author URI: http://www.tuxlog.de
*/

/*  Copyright 2006,2007  Hans Matzen  (email : webmaster at tuxlog.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// include setup functions
require_once("setup.php");
// include admin options page
require_once("wp-forecast-admin.php");
  

function widget_wp_forecast_init()
{
 
  // include translations
  require_once("language.php");
  // generic functions
  require_once("functions.php");
 
  // get options
  global $location, $refresh,$metric,$wpf_language,$windunit,$xmlerror;
  global $daytime,$nighttime,$fc_date_format,$BASE_URI,$dispconfig;
  global $fc_time_format,$locname;
  $location=get_option("wp-forecast-location");
  $locname=get_option("wp-forecast-locname");
  $refresh=get_option("wp-forecast-refresh"); 
  $metric=get_option("wp-forecast-metric"); 
  $wpf_language=get_option("wp-forecast-language");
  $daytime=get_option("wp-forecast-daytime");
  $nighttime=get_option("wp-forecast-nighttime");
  $fc_date_format=get_option("date_format");
  $fc_time_format=get_option("time_format");
  $dispconfig=get_option("wp-forecast-dispconfig");
  $windunit=get_option("wp-forecast-windunit");
  $xmlerror="";
  
  $BASE_URI="http://forecastfox.accuweather.com/adcbin/forecastfox/weather_data.asp?";
  
  // fill language array
  global $tl;
  $tl=array();
  $tl=set_translation($wpf_language);
  
  // these are the xml-paths we wish to fetch from the weather-data
  global $path_tabelle;
  $path_tabelle = 
    array(
	  "/ADC_DATABASE/UNITS/TEMP"  => "un_temp",
	  "/ADC_DATABASE/UNITS/DIST"  => "un_dist",
	  "/ADC_DATABASE/UNITS/SPEED" => "un_speed",
	  "/ADC_DATABASE/UNITS/PRES"  => "un_pres",
	  "/ADC_DATABASE/UNITS/PREC"  => "un_prec",
	  "/ADC_DATABASE/LOCAL/CITY"  => "city",
	  "/ADC_DATABASE/LOCAL/STATE" => "state",
	  "/ADC_DATABASE/LOCAL/TIME"  => "time",
	  "/ADC_DATABASE/CURRENTCONDITIONS/PRESSURE"  => "pressure",
	  "/ADC_DATABASE/CURRENTCONDITIONS/TEMPERATURE"  => "temperature",
	  "/ADC_DATABASE/CURRENTCONDITIONS/REALFEEL"  => "realfeel",
	  "/ADC_DATABASE/CURRENTCONDITIONS/HUMIDITY"  => "humidity",
	  "/ADC_DATABASE/CURRENTCONDITIONS/WEATHERTEXT"  => "weathertext",
	  "/ADC_DATABASE/CURRENTCONDITIONS/WEATHERICON"  => "weathericon",
	  "/ADC_DATABASE/CURRENTCONDITIONS/WINDSPEED"  => "windspeed",
	  "/ADC_DATABASE/CURRENTCONDITIONS/WINDDIRECTION"  => "winddirection",
	  "/ADC_DATABASE/PLANETS/SUN" => "sun",
	  "/ADC_DATABASE/FORECAST/DAY/OBSDATE"  => "fc_obsdate",
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/TXTSHORT"  => "fc_dt_short",
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/WEATHERICON"  => "fc_dt_icon",
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/HIGHTEMPERATURE"  => "fc_dt_htemp",  
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/LOWTEMPERATURE"  => "fc_dt_ltemp",   
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/WINDSPEED"  => "fc_dt_windspeed",
	  "/ADC_DATABASE/FORECAST/DAY/DAYTIME/WINDDIRECTION"  => "fc_dt_winddir",
	  "/ADC_DATABASE/FORECAST/DAY/NIGHTTIME/WEATHERICON"  => "fc_nt_icon",
	  "/ADC_DATABASE/FORECAST/DAY/NIGHTTIME/HIGHTEMPERATURE"  => "fc_nt_htemp",  
	  "/ADC_DATABASE/FORECAST/DAY/NIGHTTIME/LOWTEMPERATURE"  => "fc_nt_ltemp",   
	  "/ADC_DATABASE/FORECAST/DAY/NIGHTTIME/WINDSPEED"  => "fc_nt_windspeed",
	  "/ADC_DATABASE/FORECAST/DAY/NIGHTTIME/WINDDIRECTION"  => "fc_nt_winddir"
	  );
  
  global $weather;
  $weather=array();
  
  
  //
  // build the url from the parameters and fetch the weather-data
  // return it as one long string
  //
  function get_weather($uri,$loc,$metric)
    {
      $url=$uri . "location=" . urlencode($loc) . "&metric=" . 
	$metric . "&partner=forecastfox";

      $xml = fetchURL($url);
      
      return $xml;
    }
  
  
  //
  // parses the xml for the paths in path_tabelle and store the values
  // in a cookie
  //
  function store_weather($weather_xml,$ref)
    {
      global $path_tabelle,$weather,$xmlerror;
      $pstack="";
      $go_ahead = "";
      $fc_daynumber="0";
      
      // start_element() - wird vom XML-Parser bei öffnenden Tags aufgerufen
      function start_element( $parser, $name, $attribute )
	{
	  // Umwandlungstabelle in den lokalen Scope holen
	  global $go_ahead,$pstack,$path_tabelle,$fc_daynumber,$weather;
	  $pstack=$pstack."/$name";
	  
	  if (isset( $path_tabelle[ $pstack])) {
	    $go_ahead = $path_tabelle[$pstack];
	    
	    if ($fc_daynumber != "0" and $fc_daynumber != "")
	      $go_ahead = $go_ahead . "_" . $fc_daynumber;
	  }
	  
	  if ($pstack=="/ADC_DATABASE/FORECAST/DAY")
	    $fc_daynumber=$attribute["NUMBER"];

	  // for current sun rise/set
	  if ($pstack=="/ADC_DATABASE/PLANETS/SUN") 
	    $weather["sun"]=$attribute["RISE"]." ".$attribute["SET"];
	    
	}
      
      // end_element() - wird vom XML-Parser bei schließenden Tags aufgerufen
      function end_element( $parser, $name )
	{
	  // pfad abbauen
	  global $pstack,$fc_daynumber;
	  $pstack = substr($pstack,0, strrpos($pstack,"/"));
	  
	  if ($name=="DAY")
	    $fc_daynumber=0;
	}
      
      // daten() - wird vom XML-Parser für CDATA-Bereiche aufgerufen 
      function daten( $parser, $data )
	{
	  global $go_ahead, $weather;
	  
	  if ( strlen($go_ahead) > 0 and $go_ahead != "sun" )
	    {
	      $weather[$go_ahead]=$data;
	      $go_ahead = '';
	    }
	}
      
      // Instanz des XML-Parsers erzeugen
      $parser = xml_parser_create();
      
      // Parameter des XML-Parsers setzen 
      xml_parser_set_option( $parser, XML_OPTION_CASE_FOLDING, true ); 
      
      // Handler für Elemente ( öffnende / schließende Tags ) setzen 
      xml_set_element_handler( $parser, "start_element", "end_element" ); 
      // Handler für Daten ( CDATA ) setzen
      xml_set_character_data_handler( $parser, "daten" );
      
      // Versuche zu parsen
      if( !xml_parse( $parser, $weather_xml,true ) )
	{
	  // Fehler -> Ausführung abbrechen
	  $xmlerror="XML Fehler: " . 
	    xml_error_string( xml_get_error_code( $parser ) ) . " in Zeile " .
	    xml_get_current_line_number( $parser )
		;
	}
      
      // Vom XML-Parser belegten Speicher freigeben
      xml_parser_free( $parser );
      
      // ergebnis als cookie speichern, wenn kein Fehler aufgetreten ist
      if ( $xmlerror=="")
	setcookie ("wp_forecast_cache", arr2str($weather),time()+$ref,"/wordpress/");
      // und zurueck geben
      return $weather;
    }

  //
  // display the weather-data 
  //
  function show($w)
    {
      global $tl,$daytime,$nighttime,$fc_date_format,$xmlerror;
      global $wpf_language,$dispconfig,$windunit,$metric,$fc_time_format;
      global $locname;
      
      // ouput current conditions
      $plugin_path = get_settings('siteurl') . '/wp-content/plugins/wp-forecast';
      $out ="";
      $out .="\n<div class=\"wp-forecast\">\n";
      $out .="<div style=\"text-align:center;\"><b>".$tl['title']."</b></div>\n";
      // im Fehlerfall nur Fehler ausgeben
      if ( $xmlerror != "") {
	$out .= $tl["Sorry, no valid weather data available."]."<br />";
	$out .= $tl["Please try again later."]."</div>";
	echo $out;
	return false;
      }

      $out .= "<div style=\"text-align:center;\">";
      if ( $locname != "" ) {
	$out .= $tl['loc'].": ".$locname."</div>\n";
      } else {
	$out .= $tl['loc'].": ".$w["city"]." ".$w["state"]."</div>\n";
      }
      $out .="<table class=\"wp-forecast\">\n";
      
      // show date / time   
      if (substr($dispconfig,18,1) == "1" or substr($dispconfig,1,1) == "1") {
	$out .= "<tr align=\"center\"><td colspan=\"2\">"; 
	if (substr($dispconfig,18,1) == "1") 
	  $out .= date_i18n($fc_date_format, strtotime($w['fc_obsdate_1']));
	  //$out .= date_i18n($fc_date_format, strtotime($w['time']));
	else
	  $out .= $tl['time'].": ";
      
	if (substr($dispconfig,18,1) == "1" and substr($dispconfig,1,1) == "1")
	  $out .= ", ";

	if (substr($dispconfig,1,1) == "1") 
	  $out .= date_i18n($fc_time_format, strtotime($w['time']))."<br />";
	$out .= "</td></tr>";
      }

      // show icon
      if (substr($dispconfig,0,1) == "1") {
	$out .= "<tr><td><img src='".$plugin_path."/icons/".$w["weathericon"].".gif' alt='".$tl[$w["weathericon"]]."' /></td>\n";
      } else {
	$out .= "<tr><td></td>\n";
      }

      $out .= "<td>";

      // show short description
      if (substr($dispconfig,2,1) == "1") 
	$out .= $tl[$w["weathericon"]]."<br />";

      // show temperatur
      if (substr($dispconfig,3,1) == "1") {
	$out .= $tl['tmp'].": ".$w["temperature"]."&deg;";
	$out .= $w['un_temp']."</td></tr></table>\n";
      } else {
	$out .="</td></tr></table>\n";
      }

      // show realfeel
      if (substr($dispconfig,4,1) == "1") 
	$out .= $tl['flik'].": ".$w["realfeel"]."&deg;".$w['un_temp']."<br />\n";
      // show pressure
      if (substr($dispconfig,5,1) == "1") 
	$out .= $tl['barr'].": ".$w["pressure"]." ".$w["un_pres"]."<br />\n";

      // show humiditiy
      if (substr($dispconfig,6,1) == "1") 
	$out .= $tl['hmid'].": ".$w["humidity"]."<br />\n";
      
      // show wind
      if (substr($dispconfig,7,1) == "1") {
	// calculate windspeed for selected unit
	$wspeed=$w["windspeed"];
	// if its mph convert it to m/s
	if ($metric != 1)
	  $wspeed = round($wspeed * 0.44704,0);
	
	// convert it to selected unit
	switch ($windunit) {
	case "ms":
	  $wunit="m/s";
	  break;
	case "kmh":
	  $wspeed=round($wspeed*3.6,0);
	  $wunit="km/h";
	  break;
	case "mph":
	  $wspeed=round($wspeed*2.23694,0);
	  $wunit="mph";
	  break;
	case "kts":
	  $wspeed=round($wspeed*1.9438,0);
	  $wunit="kts";
	  break;
	}
	$winddir=$w["winddirection"];
	// for german language replace East with Ost or E with O
	if ($wpf_language=="de")
	  $winddir=str_replace("E","O",$winddir);

	$out .= $tl['winds'].": ".$wspeed." ".$wunit." " . $winddir."<br />\n";
      }

      $sunarr = explode(" ",$w["sun"]);

      // show sunrise
      if (substr($dispconfig,8,1) == "1")
	$out .= $tl['sunrise'].": ".$sunarr[0]."<br />\n";

      // show sunset
      if (substr($dispconfig,9,1) == "1")
	$out .= $tl['sunset'].": ".$sunarr[1]."<br />\n";

      // show copyright
      if (substr($dispconfig,21,1) == "1")
	$out .= "<div style=\"text-align:center;\"><font size='-3'><a href=\"http://www.accuweather.com\">&copy; 2007 AccuWeather, Inc.</a></font></div>";

      $out .="</div><br />\n";
      echo $out;
      
      // output forecast
      $out1="";
      for ($i = 1; $i < 10; $i++) {
	
	// check active forecast for day number i
	if (substr($daytime,$i-1,1)=="1" or substr($nighttime,$i-1,1) =="1") {
	  $out1 .="\n<div class=\"wp-forecast\">\n";
	  $out1 .= $tl["Forecast"]." ";
	  $out1 .= date_i18n($fc_date_format, strtotime($w['fc_obsdate_'.$i]))."<br />";
	}
	
	// check for daytime information
	if (substr($daytime,$i-1,1)=="1" ) {
	  $out1 .="<table class=\"wp-forecast\" cellpadding='3' cellspacing='2'>\n";
	  $out1 .= "<tr><td valign='top' align='center'>".$tl['day']."<br />";
	  
	  // show icon
	  if (substr($dispconfig,10,1) == "1") {
	    $out1 .= "<img src='".$plugin_path."/icons/".$w["fc_dt_icon_".$i].".gif' width='48' alt='".$tl[$w["fc_dt_icon_".$i]]."' />";
	  } else {
	    $out1 .= "&nbsp;";
	  }
	  $out1 .= "</td><td>\n";

	  // show short description
	  if (substr($dispconfig,11,1) == "1")
	    $out1 .= $tl[$w["fc_dt_icon_".$i]]."<br />";

	  // show temperature
	  if (substr($dispconfig,12,1) == "1") 
	    $out1 .= $w["fc_dt_htemp_".$i]."&deg;".$w['un_temp']."<br />";
	  

	  // show wind
	  if (substr($dispconfig,13,1) == "1") {
	    // calculate windspeed for selected unit
	    $wspeed=$w["fc_dt_windspeed_".$i];
	      // if its mph convert it to m/s
	      if ($metric != 1)
		$wspeed = round($wspeed * 0.44704,0);
	    
	    // convert it to selected unit
	    switch ($windunit) {
	    case "ms":
	      $wunit="m/s";
	      break;
	    case "kmh":
	      $wspeed=round($wspeed*3.6,0);
	      $wunit="km/h";
	      break;
	    case "mph":
	      $wspeed=round($wspeed*2.23694,0);
	      $wunit="mph";
	      break;
	    case "kts":
	      $wspeed=round($wspeed*1.9438,0);
	      $wunit="kts";
	      break;
	    }
	    $winddir=$w["fc_dt_winddir_".$i];
	    // for german language replace East with Ost or E with O
	    if ($wpf_language=="de")
	      $winddir=str_replace("E","O",$winddir);

	    $out1 .= $tl['winds'].": ".$wspeed." ".$wunit." " . $winddir."\n";
	  }
	  $out1 .= "</td></tr></table>\n";
	}

	// check for nighttime information
	if (substr($nighttime,$i-1,1)=="1" ) {
	  $out1 .="<table class=\"wp-forecast\" cellpadding='3' cellspacing='2'>\n";
	  $out1 .= "<tr><td valign='top' align='center'>".$tl['night']."<br />";
	  if (substr($dispconfig,14,1) == "1") { 
	    $out1 .= "<img src='".$plugin_path."/icons/".$w["fc_nt_icon_".$i].".gif' width='48' alt='".$tl[$w["fc_nt_icon_".$i]]."' />";
	  } else {
	    $out1 .= "&nbsp;";
	  }
	  $out1 .= "</td><td>\n";
	  
	  // show short description
	  if (substr($dispconfig,15,1) == "1") 
	    $out1 .= $tl[$w["fc_nt_icon_".$i]]."<br />";
	   
	  // show temperature
	  if (substr($dispconfig,16,1) == "1") {
	    $out1 .= $w["fc_nt_ltemp_".$i]."&deg;".$w['un_temp']."<br />";
	  }

	  // show wind
	  if (substr($dispconfig,17,1) == "1") {
	    // calculate windspeed for selected unit
	    $wspeed=$w["fc_nt_windspeed_".$i];
	      // if its mph convert it to m/s
	      if ($metric != 1)
		$wspeed = round($wspeed * 0.44704,0);
	    
	    // convert it to selected unit
	    switch ($windunit) {
	    case "ms":
	      $wunit="m/s";
	      break;
	    case "kmh":
	      $wspeed=round($wspeed*3.6,0);
	      $wunit="km/h";
	      break;
	    case "mph":
	      $wspeed=round($wspeed*2.23694,0);
	      $wunit="mph";
	      break;
	    case "kts":
	      $wspeed=round($wspeed*1.9438,0);
	      $wunit="kts";
	      break;
	    }
	    $winddir=$w["fc_dt_winddir_".$i];
	    // for german language replace East with Ost or E with O
	    if ($wpf_language=="de")
	      $winddir=str_replace("E","O",$winddir);

	    $out1 .= $tl['winds'].": ".$wspeed." ".$wunit." ".$winddir."\n";
	  }
	  $out1 .= "</td></tr></table>\n";
	}	
	// close div block
	if (substr($daytime,$i-1,1)=="1" or substr($nighttime,$i-1,1) =="1") 
	  $out1 .="</div>\n";
      }
      echo $out1;
    }
  
  //
  // just return the css link
  // this function is called via the wp_head hook
  //
  function wp_forecast_css() {
    $plugin_path = get_settings('siteurl') . '/wp-content/plugins/wp-forecast';
    echo "<link rel=\"stylesheet\" href=\"". $plugin_path. "/wp-forecast.css\" type=\"text/css\" media=\"screen\" />\n";
  }
  
  //
  // set cookie with weather data for current parameters
  // a wrapper function called via the init hook
  //
  function wp_forecast_init() 
    {
      global $location,$refresh,$metric,$daytime,$nighttime,$wpf_language;
      global $BASE_URI,$path_tabelle,$weather;
      
      if (! isset($_COOKIE["wp_forecast_cache"] ))
	{
	  $w = get_weather($BASE_URI,$location,$metric);
	  $weather=store_weather($w,$refresh);
	}
    }
  
  // 
  // this function is called from your template
  // to insert your weather data at the place you want it to be
  //
  function wp_forecast()
    {
      global $weather;
      if (isset ($_COOKIE["wp_forecast_cache"]) )
	$weather=str2arr($_COOKIE["wp_forecast_cache"]);
      //print_r ($weather);
      show($weather);
    }
  
  //
  // map the various functions to the hooks
  //
 
  // add option page 
  //add_action('admin_menu', 'wp_forecast_admin');
  
  // add fetch weather data to init the cookie before any headers are sent
  add_action('init','wp_forecast_init');
  add_action('init','wp_forecast_admin_init');
  
  // add css in header
  add_action('wp_head', 'wp_forecast_css');
  
  
  // This registers our widget so it appears with the other available
  // widgets and can be dragged and dropped into any active sidebars.
  register_sidebar_widget(array('wp-forecast', 'widgets'), 'wp_forecast');
  
  // This registers our optional widget control form. 
  register_widget_control(array('wp-forecast', 'widgets'), 'admin_form', 900, 500,1);
}

// add activate/deactivate to not mess up the database
//add_action('activate_wp-forecast/setup.php','wp_forecast_activate');
//add_action('deactivate_wp-forecast/setup.php','wp_forecast_deactivate');

register_activation_hook(__FILE__,'wp_forecast_activate');
register_deactivation_hook(__FILE__,'wp_forecast_deactivate');

// add option page 
add_action('admin_menu', 'wp_forecast_admin');

// Run our code later in case this loads prior to any required plugins.
add_action('widgets_init', 'widget_wp_forecast_init');
?>
